package com.ejie.p06b.dao;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Locale;

import com.ejie.p06b.datatype.model.P06B24T00Datatype;
import com.ejie.p06b.datatype.model.P06B61T00Datatype;
import com.ejie.p06b.general.P06BConstantes;
import com.ejie.p06b.general.P06BTablas;
import com.ejie.p06b.log.P06BLog;
import com.ejie.p06b.util.P06BFecha;
import com.ejie.p06b.util.bd.P06BServidorConexionesBD;

/**
 * XXXX
 * Inserte aqu� la descripci�n del tipo.
 * Fecha de creaci�n: (04/06/07)
 */
public class P06B61T00DAO {

	static private P06B61T00DAO instance = null;

	public static P06B61T00DAO getInstance() {
	     if (instance == null) {
	          synchronized (P06B61T00DAO.class) {
	          		if (instance == null) {
	                     instance = new P06B61T00DAO();
	                }
	          }
	     }
	     return instance;
	}

	/**
    * Inserta un registro de la BD
    * @param obj.
    *            objeto a insertar
    * @return void
    * @throws SQLException
    */
	public void insert(P06B61T00Datatype obj) throws SQLException{
		P06BLog.send(2,this, "Inicio P06B61T00DAO-insert");

		PreparedStatement lstm  = null;
        ResultSet lrst  = null;
        Connection lconConexion = P06BServidorConexionesBD.getConexionConsultas();
        String sql = INSERT_COMPLETA;
        lstm = lconConexion.prepareStatement(sql);

        lstm.setString(1,obj.getExpedi().toUpperCase());
	    lstm.setString(2,obj.getCif().toUpperCase());
	    lstm.setString(3,obj.getEntidad().toUpperCase());
	    lstm.setString(4,obj.getCalle().toUpperCase());
	    lstm.setString(5,obj.getPortal().toUpperCase());
	    lstm.setString(6,obj.getPiso().toUpperCase());
	    lstm.setString(7,obj.getLetra().toUpperCase());
	    lstm.setString(8,obj.getCodpro().toUpperCase());
	    lstm.setString(9,obj.getCodmun().toUpperCase());
	    lstm.setString(10,obj.getLocali().toUpperCase());
	    lstm.setString(11,obj.getCodpst().toUpperCase());
	    lstm.setString(12,obj.getClavecat().toUpperCase());
	    lstm.setString(13,obj.getFhInscrip().toUpperCase());

    	lstm.executeUpdate();
    	//Cierro recursos
    	try {
    		if(lrst!=null) lrst.close();
    	}catch (Exception rse) {}
        try {
        	if(lstm!=null) lstm.close();
        }catch (Exception sse) {}
        try {
        	if(lconConexion!=null)lconConexion.close();
        }catch (Exception cse) {}
        P06BLog.send(2,this, "Fin P06B61T00DAO-insert");
	}

	/**
    * Obtiene la lista de socios asociados al expediente
    * @param expediente.
    * @param tipo 1:socio directo 2:socio indirecto 3:auxiliar externo
    * @return Lista de objetos socios
	 * @throws Exception
    */
	public ArrayList<P06B61T00Datatype> selectAllByExp(String expediente, String order) throws Exception{
		P06BLog.send(2,this, "Inicio P06B61T00Datatype-selectAllByExp");
		ArrayList<P06B61T00Datatype> lista = new ArrayList<P06B61T00Datatype>();
		P06B61T00Datatype obj = null;
		PreparedStatement lstm  = null;
        ResultSet lrst  = null;
        String sql = SELECTALL_BY_EXP;
        if (expediente!=null){
        	if (!"".equals(expediente.trim())){
        		sql = sql + " WHERE " + P06BTablas.P06B_P06B61_EV_NUMEXP + "= ?";
        	}
        }
        if (order!=null){
        	if (!"".equals(order.trim())){
        		sql = sql + " ORDER BY " + order;
        	}
        }

        Connection lconConexion = P06BServidorConexionesBD.getConexionConsultas();
        try {
        	lstm = lconConexion.prepareStatement(sql);
            if (expediente!=null){
            	if (!"".equals(expediente.trim())){
                	lstm.setString(1,expediente.toUpperCase());
            	}
            }
        	lrst = lstm.executeQuery();
        	//int cont = 0; //TODO Para que se usa cont??????? pq se le asigna al numExp????
	        while (lrst.next()) {
	        	obj = new P06B61T00Datatype();
	        	//obj.setNExpediente(cont+"");
			    obj.setExpedi(lrst.getString(P06BTablas.P06B_P06B61_EV_NUMEXP));
	        	obj.setCif(lrst.getString(P06BTablas.P06B_P06B61_EV_CIF));
			    obj.setEntidad(lrst.getString(P06BTablas.P06B_P06B61_EV_ENTIDAD));
			    obj.setCalle(lrst.getString(P06BTablas.P06B_P06B61_EV_CALLE)==null?"":lrst.getString(P06BTablas.P06B_P06B61_EV_CALLE));
			    obj.setPortal(lrst.getString(P06BTablas.P06B_P06B61_EV_PORTAL)==null?"":lrst.getString(P06BTablas.P06B_P06B61_EV_PORTAL));
			    obj.setPiso(lrst.getString(P06BTablas.P06B_P06B61_EV_PISO)==null?"":lrst.getString(P06BTablas.P06B_P06B61_EV_PISO));
			    obj.setLetra(lrst.getString(P06BTablas.P06B_P06B61_EV_LETRA)==null?"":lrst.getString(P06BTablas.P06B_P06B61_EV_LETRA));
			    obj.setCodpro(lrst.getString(P06BTablas.P06B_P06B61_EV_CODPRO)==null?"":lrst.getString(P06BTablas.P06B_P06B61_EV_CODPRO));
			    obj.setCodmun(lrst.getString(P06BTablas.P06B_P06B61_EV_CODMUN)==null?"":lrst.getString(P06BTablas.P06B_P06B61_EV_CODMUN));
			    obj.setLocali(lrst.getString(P06BTablas.P06B_P06B61_EV_LOCALID)==null?"":lrst.getString(P06BTablas.P06B_P06B61_EV_LOCALID));
			    obj.setCodpst(lrst.getString(P06BTablas.P06B_P06B61_EV_CODPST)==null?"":lrst.getString(P06BTablas.P06B_P06B61_EV_CODPST));
			    obj.setClavecat(lrst.getString(P06BTablas.P06B_P06B61_EV_CLAVECAT)==null?"":lrst.getString(P06BTablas.P06B_P06B61_EV_CLAVECAT));
			    obj.setFhInscrip(lrst.getString(P06BTablas.P06B_P06B61_EV_FH_INSCRIP)==null?"":P06BFecha.getFechaFormateada(lrst.getDate(P06BTablas.P06B_P06B61_EV_FH_INSCRIP),new Locale(P06BConstantes.P06B_IDIOMA_ES)));

	        	//cont++;
	        	lista.add(obj);
	        }
	        P06BLog.send(2,this, "Fin P06B61T00Datatype-selectAllByExp");
	    } catch (SQLException e) {
	    	P06BLog.send(2,this, "error: " +e.getMessage());
        	try {
        		if(lrst!=null)
        			lrst.close();
        	}catch (Exception rse) {}
	        try {
	        	if(lstm!=null)
	        		lstm.close();
	        }catch (Exception sse) {}
	        try {
	        	if(lconConexion!=null)
	        		lconConexion.close();
	        }catch (Exception cse) {}
	        //Propago la excepci�n
	        throw e;
	    }catch (Exception e2) {
        	P06BLog.send(2,this, "error: " +e2.getMessage());
        	try {
        		if(lrst!=null)
        			lrst.close();
        	}catch (Exception rse) {}
	        try {
	        	if(lstm!=null)
	        		lstm.close();
	        }catch (Exception sse) {}
	        try {
	        	if(lconConexion!=null)
	        		lconConexion.close();
	        }catch (Exception cse) {}
	        //P)ropago la excepci�n
	        throw e2;
	    }finally {
	    	try {
        		if(lrst!=null)
        			lrst.close();
        	}catch (Exception rse) {}
	        try {
	        	if(lstm!=null)
	        		lstm.close();
	        }catch (Exception sse) {}
	        try {
	        	if(lconConexion!=null)
	        		lconConexion.close();
	        }catch (Exception cse) {}
	    }
		return lista;
	}


	/**
    * Obtiene la lista de socios asociados al expediente
    * @param expediente.
    * @param tipo 1:socio directo 2:socio indirecto 3:auxiliar externo
    * @return Lista de objetos socios
	 * @throws Exception
    */
	public ArrayList select61ByIncorporacionDEC(String expediente, int nEjerIncorporarDEC) throws SQLException{
		P06BLog.send(2,this, "Inicio P06B61T00DAO-select61ByIncorporacionDEC");
		ArrayList lista = new ArrayList();
		P06B61T00Datatype obj61 = null;
		PreparedStatement lstm  = null;
        ResultSet lrst  = null;
        String sql = SELECTALL_INCORPORACION_BY_EXP;
        Connection lconConexion = P06BServidorConexionesBD.getConexionConsultas();
        try {
        	lstm = lconConexion.prepareStatement(sql);
        	lstm.setString(1,expediente.toUpperCase());
        	lstm.setInt(2,nEjerIncorporarDEC);
        	lstm.setString(3,expediente.toUpperCase());
        	lstm.setString(4,expediente.toUpperCase());
        	lstm.setInt(5,nEjerIncorporarDEC);
        	lstm.setString(6,expediente.toUpperCase());
        	lstm.setString(7,expediente.toUpperCase());
        	lstm.setInt(8,nEjerIncorporarDEC);
        	lstm.setString(9,expediente.toUpperCase());
        	lstm.setString(10,expediente.toUpperCase());
        	lrst = lstm.executeQuery();
        	//int cont = 0; //TODO Para que se usa cont??????? pq se le asigna al numExp????
	        while (lrst.next()) {
	        	int operacion = lrst.getInt("operacion");
	        	boolean moverCampos61 = false;
	        	boolean moverCampos43 = false;
	        	boolean bHayDatosOriginales = false;
	        	if (operacion==0){
	        		moverCampos61 = true;
	        		bHayDatosOriginales = true;
	        	}else if (operacion==1){
	        		moverCampos43 = true;
	        	}else if (operacion==2){
	        		moverCampos61 = true;
	        		moverCampos43 = true;
	        		bHayDatosOriginales = true;
	        	}

	        	obj61 = new P06B61T00Datatype();
	        	obj61.setOperacion(operacion);
	        	if (moverCampos61==true){
				    obj61.setExpedi(expediente.toUpperCase());
		        	obj61.setCif(lrst.getString(P06BTablas.P06B_P06B61_EV_CIF));
				    obj61.setEntidad(lrst.getString(P06BTablas.P06B_P06B61_EV_ENTIDAD));
				    obj61.setCalle(lrst.getString(P06BTablas.P06B_P06B61_EV_CALLE)==null?"":lrst.getString(P06BTablas.P06B_P06B61_EV_CALLE));
				    obj61.setPortal(lrst.getString(P06BTablas.P06B_P06B61_EV_PORTAL)==null?"":lrst.getString(P06BTablas.P06B_P06B61_EV_PORTAL));
				    obj61.setPiso(lrst.getString(P06BTablas.P06B_P06B61_EV_PISO)==null?"":lrst.getString(P06BTablas.P06B_P06B61_EV_PISO));
				    obj61.setLetra(lrst.getString(P06BTablas.P06B_P06B61_EV_LETRA)==null?"":lrst.getString(P06BTablas.P06B_P06B61_EV_LETRA));
				    obj61.setCodpro(lrst.getString(P06BTablas.P06B_P06B61_EV_CODPRO)==null?"":lrst.getString(P06BTablas.P06B_P06B61_EV_CODPRO));
				    obj61.setCodmun(lrst.getString(P06BTablas.P06B_P06B61_EV_CODMUN)==null?"":lrst.getString(P06BTablas.P06B_P06B61_EV_CODMUN));
				    obj61.setLocali(lrst.getString(P06BTablas.P06B_P06B61_EV_LOCALID)==null?"":lrst.getString(P06BTablas.P06B_P06B61_EV_LOCALID));
				    obj61.setCodpst(lrst.getString(P06BTablas.P06B_P06B61_EV_CODPST)==null?"":lrst.getString(P06BTablas.P06B_P06B61_EV_CODPST));
				    obj61.setClavecat(lrst.getString(P06BTablas.P06B_P06B61_EV_CLAVECAT)==null?"":lrst.getString(P06BTablas.P06B_P06B61_EV_CLAVECAT));
				    obj61.setFhInscrip(lrst.getString(P06BTablas.P06B_P06B61_EV_FH_INSCRIP)==null?"":P06BFecha.getFechaFormateada(lrst.getDate(P06BTablas.P06B_P06B61_EV_FH_INSCRIP),new Locale(P06BConstantes.P06B_IDIOMA_ES)));
	        	}

	        	if (moverCampos43==true){
				    obj61.setExpedi(expediente.toUpperCase());
				    obj61.setClavecat(lrst.getString(P06BTablas.P06B_P06B43_CLAVE));
				    obj61.setEntidad(lrst.getString(P06BTablas.P06B_P06B43_DENOM)==null?"":lrst.getString(P06BTablas.P06B_P06B43_DENOM));
				    obj61.setFhInscrip(lrst.getString(P06BTablas.P06B_P06B43_FH_INSCRIP)==null?"":P06BFecha.getFechaFormateada(lrst.getDate(P06BTablas.P06B_P06B43_FH_INSCRIP),new Locale(P06BConstantes.P06B_IDIOMA_ES)));

	        	}
//			    obj61.setAprobado(0);

			    if (bHayDatosOriginales==true){
			    	P06B61T00Datatype datos61Originales = new P06B61T00Datatype();
				    datos61Originales.setExpedi(expediente.toUpperCase());
		        	datos61Originales.setCif(lrst.getString(P06BTablas.P06B_P06B61_EV_CIF));
				    datos61Originales.setEntidad(lrst.getString(P06BTablas.P06B_P06B61_EV_ENTIDAD));
				    datos61Originales.setCalle(lrst.getString(P06BTablas.P06B_P06B61_EV_CALLE)==null?"":lrst.getString(P06BTablas.P06B_P06B61_EV_CALLE));
				    datos61Originales.setPortal(lrst.getString(P06BTablas.P06B_P06B61_EV_PORTAL)==null?"":lrst.getString(P06BTablas.P06B_P06B61_EV_PORTAL));
				    datos61Originales.setPiso(lrst.getString(P06BTablas.P06B_P06B61_EV_PISO)==null?"":lrst.getString(P06BTablas.P06B_P06B61_EV_PISO));
				    datos61Originales.setLetra(lrst.getString(P06BTablas.P06B_P06B61_EV_LETRA)==null?"":lrst.getString(P06BTablas.P06B_P06B61_EV_LETRA));
				    datos61Originales.setCodpro(lrst.getString(P06BTablas.P06B_P06B61_EV_CODPRO)==null?"":lrst.getString(P06BTablas.P06B_P06B61_EV_CODPRO));
				    datos61Originales.setCodmun(lrst.getString(P06BTablas.P06B_P06B61_EV_CODMUN)==null?"":lrst.getString(P06BTablas.P06B_P06B61_EV_CODMUN));
				    datos61Originales.setLocali(lrst.getString(P06BTablas.P06B_P06B61_EV_LOCALID)==null?"":lrst.getString(P06BTablas.P06B_P06B61_EV_LOCALID));
				    datos61Originales.setCodpst(lrst.getString(P06BTablas.P06B_P06B61_EV_CODPST)==null?"":lrst.getString(P06BTablas.P06B_P06B61_EV_CODPST));
				    datos61Originales.setClavecat(lrst.getString(P06BTablas.P06B_P06B61_EV_CLAVECAT)==null?"":lrst.getString(P06BTablas.P06B_P06B61_EV_CLAVECAT));
				    datos61Originales.setFhInscrip(lrst.getString(P06BTablas.P06B_P06B61_EV_FH_INSCRIP)==null?"":P06BFecha.getFechaFormateada(lrst.getDate(P06BTablas.P06B_P06B61_EV_FH_INSCRIP),new Locale(P06BConstantes.P06B_IDIOMA_ES)));
				    obj61.setDatos61Originales(datos61Originales);
        		}

			    //Ojo con los Double, Cambio los puntos por comas
//				    obj34.setParticipa(obj34.getParticipa().replaceAll("\\.",","));
				//Si el idioma es euskera, formatear correctamente las fechas
//					if(idioma.equals(P06BConstantes.P06B_IDIOMA_EU)){
//						obj34.setFecAlta(P06BFecha.fechaEuFromFecha(obj34.getFecAlta()));
//					}

	        	//cont++;
	        	lista.add(obj61);
	        }
	        P06BLog.send(2,this, "Fin P06B61T00DAO-select61ByIncorporacionDEC");
	    } catch (SQLException e) {
	    	P06BLog.send(2,this, "error: " +e.getMessage());
	    }finally {
 		if(lrst!=null)
 			lrst.close();
        	if(lstm!=null)
        		lstm.close();
        	if(lconConexion!=null)
        		lconConexion.close();
	    }
		return lista;
	}

	/**
    * Obtiene la lista de socios asociados al expediente
    * @param expediente.
    * @param tipo 1:socio directo 2:socio indirecto 3:auxiliar externo
    * @return Lista de objetos socios
	 * @throws Exception
    */
	public ArrayList select61ByIncorporacionModTramitagune(String expediente, int nCorrelAtencionPeticionEnRevision) throws SQLException{
		P06BLog.send(2,this, "Inicio P06B61T00DAO-select61ByIncorporacionModTramitagune");
		ArrayList lista = new ArrayList();
		P06B61T00Datatype obj61 = null;
		PreparedStatement lstm  = null;
        ResultSet lrst  = null;
        String sql = SELECTALL_INCORPORACIONMODTRAMITAGUNE_BY_EXP;
        Connection lconConexion = P06BServidorConexionesBD.getConexionConsultas();
        try {
        	lstm = lconConexion.prepareStatement(sql);
        	lstm.setString(1,expediente.toUpperCase());
        	lstm.setString(2,expediente.toUpperCase());
        	lstm.setInt(3,nCorrelAtencionPeticionEnRevision);
        	lstm.setString(4,expediente.toUpperCase());
        	lstm.setString(5,expediente.toUpperCase());
        	lstm.setInt(6,nCorrelAtencionPeticionEnRevision);
        	lstm.setInt(7,P06BConstantes.P06B_TO_ALTA);
        	lstm.setString(8,expediente.toUpperCase());
        	lstm.setInt(9,nCorrelAtencionPeticionEnRevision);
        	lstm.setInt(10,P06BConstantes.P06B_TO_ALTA);
        	lstm.setString(11,expediente.toUpperCase());
        	lstm.setString(12,expediente.toUpperCase());
        	lrst = lstm.executeQuery();
        	//int cont = 0; //TODO Para que se usa cont??????? pq se le asigna al numExp????
	        while (lrst.next()) {
	        	int operacion = lrst.getInt("operacion");
	        	boolean moverCampos61 = false;
	        	boolean moverCampos43 = false;
	        	boolean bHayDatosOriginales = false;
	        	if (operacion==0){
	        		moverCampos61 = true;
	        		bHayDatosOriginales = true;
	        	}else if (operacion==1){
	        		moverCampos43 = true;
	        	}else if (operacion==2){
	        		moverCampos61 = true;
	        		moverCampos43 = true;
	        		bHayDatosOriginales = true;
	        	}

	        	obj61 = new P06B61T00Datatype();
			    obj61.setExpedi(expediente.toUpperCase());
	        	obj61.setOperacion(operacion);
//			    obj61.setAprobado(0);
	        	if (operacion==0){
		        	obj61.setCif(lrst.getString(P06BTablas.P06B_P06B61_EV_CIF));
				    obj61.setEntidad(lrst.getString(P06BTablas.P06B_P06B61_EV_ENTIDAD));
				    obj61.setClavecat(lrst.getString(P06BTablas.P06B_P06B61_EV_CLAVECAT)==null?"":lrst.getString(P06BTablas.P06B_P06B61_EV_CLAVECAT));
			    	//Campos no aportados por Tramitagune para que no se pierdan
				    obj61.setCalle(lrst.getString(P06BTablas.P06B_P06B61_EV_CALLE)==null?"":lrst.getString(P06BTablas.P06B_P06B61_EV_CALLE));
				    obj61.setPortal(lrst.getString(P06BTablas.P06B_P06B61_EV_PORTAL)==null?"":lrst.getString(P06BTablas.P06B_P06B61_EV_PORTAL));
				    obj61.setPiso(lrst.getString(P06BTablas.P06B_P06B61_EV_PISO)==null?"":lrst.getString(P06BTablas.P06B_P06B61_EV_PISO));
				    obj61.setLetra(lrst.getString(P06BTablas.P06B_P06B61_EV_LETRA)==null?"":lrst.getString(P06BTablas.P06B_P06B61_EV_LETRA));
				    obj61.setCodpro(lrst.getString(P06BTablas.P06B_P06B61_EV_CODPRO)==null?"":lrst.getString(P06BTablas.P06B_P06B61_EV_CODPRO));
				    obj61.setCodmun(lrst.getString(P06BTablas.P06B_P06B61_EV_CODMUN)==null?"":lrst.getString(P06BTablas.P06B_P06B61_EV_CODMUN));
				    obj61.setLocali(lrst.getString(P06BTablas.P06B_P06B61_EV_LOCALID)==null?"":lrst.getString(P06BTablas.P06B_P06B61_EV_LOCALID));
				    obj61.setCodpst(lrst.getString(P06BTablas.P06B_P06B61_EV_CODPST)==null?"":lrst.getString(P06BTablas.P06B_P06B61_EV_CODPST));
				    obj61.setFhInscrip(lrst.getString(P06BTablas.P06B_P06B61_EV_FH_INSCRIP)==null?"":P06BFecha.getFechaFormateada(lrst.getDate(P06BTablas.P06B_P06B61_EV_FH_INSCRIP),new Locale(P06BConstantes.P06B_IDIOMA_ES)));
	        	}

	        	if (operacion==1 || operacion==2){
				    obj61.setCif(lrst.getString(P06BTablas.P06B_P06B71_EV_CIF));
				    obj61.setClavecat(lrst.getString(P06BTablas.P06B_P06B71_EV_CLAVECAT));
				    obj61.setEntidad(lrst.getString(P06BTablas.P06B_P06B71_EV_ENTIDAD));
				    obj61.setAltaBaja(lrst.getByte(P06BTablas.P06B_P06B71_EV_ALTABAJA));
				    //obj61.setFhInscrip(null);
				    if (operacion==2){
				    	//Inicializar campos no aportados por Tramitagune para que no se pierdan
					    obj61.setCalle(lrst.getString(P06BTablas.P06B_P06B61_EV_CALLE)==null?"":lrst.getString(P06BTablas.P06B_P06B61_EV_CALLE));
					    obj61.setPortal(lrst.getString(P06BTablas.P06B_P06B61_EV_PORTAL)==null?"":lrst.getString(P06BTablas.P06B_P06B61_EV_PORTAL));
					    obj61.setPiso(lrst.getString(P06BTablas.P06B_P06B61_EV_PISO)==null?"":lrst.getString(P06BTablas.P06B_P06B61_EV_PISO));
					    obj61.setLetra(lrst.getString(P06BTablas.P06B_P06B61_EV_LETRA)==null?"":lrst.getString(P06BTablas.P06B_P06B61_EV_LETRA));
					    obj61.setCodpro(lrst.getString(P06BTablas.P06B_P06B61_EV_CODPRO)==null?"":lrst.getString(P06BTablas.P06B_P06B61_EV_CODPRO));
					    obj61.setCodmun(lrst.getString(P06BTablas.P06B_P06B61_EV_CODMUN)==null?"":lrst.getString(P06BTablas.P06B_P06B61_EV_CODMUN));
					    obj61.setLocali(lrst.getString(P06BTablas.P06B_P06B61_EV_LOCALID)==null?"":lrst.getString(P06BTablas.P06B_P06B61_EV_LOCALID));
					    obj61.setCodpst(lrst.getString(P06BTablas.P06B_P06B61_EV_CODPST)==null?"":lrst.getString(P06BTablas.P06B_P06B61_EV_CODPST));
					    obj61.setFhInscrip(lrst.getString(P06BTablas.P06B_P06B61_EV_FH_INSCRIP)==null?"":P06BFecha.getFechaFormateada(lrst.getDate(P06BTablas.P06B_P06B61_EV_FH_INSCRIP),new Locale(P06BConstantes.P06B_IDIOMA_ES)));
				    }
	        	}

			    if (operacion==0 || operacion==2){
			    	P06B61T00Datatype datos61Originales = new P06B61T00Datatype();
				    datos61Originales.setExpedi(expediente.toUpperCase());
		        	datos61Originales.setCif(lrst.getString(P06BTablas.P06B_P06B61_EV_CIF));
		        	datos61Originales.setClavecat(lrst.getString(P06BTablas.P06B_P06B61_EV_CLAVECAT)==null?"":lrst.getString(P06BTablas.P06B_P06B61_EV_CLAVECAT));
				    datos61Originales.setEntidad(lrst.getString(P06BTablas.P06B_P06B61_EV_ENTIDAD));
				    datos61Originales.setCalle(lrst.getString(P06BTablas.P06B_P06B61_EV_CALLE)==null?"":lrst.getString(P06BTablas.P06B_P06B61_EV_CALLE));
				    datos61Originales.setPortal(lrst.getString(P06BTablas.P06B_P06B61_EV_PORTAL)==null?"":lrst.getString(P06BTablas.P06B_P06B61_EV_PORTAL));
				    datos61Originales.setPiso(lrst.getString(P06BTablas.P06B_P06B61_EV_PISO)==null?"":lrst.getString(P06BTablas.P06B_P06B61_EV_PISO));
				    datos61Originales.setLetra(lrst.getString(P06BTablas.P06B_P06B61_EV_LETRA)==null?"":lrst.getString(P06BTablas.P06B_P06B61_EV_LETRA));
				    datos61Originales.setCodpro(lrst.getString(P06BTablas.P06B_P06B61_EV_CODPRO)==null?"":lrst.getString(P06BTablas.P06B_P06B61_EV_CODPRO));
				    datos61Originales.setCodmun(lrst.getString(P06BTablas.P06B_P06B61_EV_CODMUN)==null?"":lrst.getString(P06BTablas.P06B_P06B61_EV_CODMUN));
				    datos61Originales.setLocali(lrst.getString(P06BTablas.P06B_P06B61_EV_LOCALID)==null?"":lrst.getString(P06BTablas.P06B_P06B61_EV_LOCALID));
				    datos61Originales.setCodpst(lrst.getString(P06BTablas.P06B_P06B61_EV_CODPST)==null?"":lrst.getString(P06BTablas.P06B_P06B61_EV_CODPST));
				    datos61Originales.setFhInscrip(lrst.getString(P06BTablas.P06B_P06B61_EV_FH_INSCRIP)==null?"":P06BFecha.getFechaFormateada(lrst.getDate(P06BTablas.P06B_P06B61_EV_FH_INSCRIP),new Locale(P06BConstantes.P06B_IDIOMA_ES)));
				    obj61.setDatos61Originales(datos61Originales);
        		}

			    //Ojo con los Double, Cambio los puntos por comas
//					    obj34.setParticipa(obj34.getParticipa().replaceAll("\\.",","));
				//Si el idioma es euskera, formatear correctamente las fechas
//						if(idioma.equals(P06BConstantes.P06B_IDIOMA_EU)){
//							obj34.setFecAlta(P06BFecha.fechaEuFromFecha(obj34.getFecAlta()));
//						}

	        	//cont++;
	        	lista.add(obj61);
	        }
	        P06BLog.send(2,this, "Fin P06B61T00DAO-select61ByIncorporacionModTramitagune");
	    }finally {
	 		if(lrst!=null)
	 			lrst.close();
        	if(lstm!=null)
        		lstm.close();
        	if(lconConexion!=null)
        		lconConexion.close();
	    }
		return lista;
	}

	/**
    * Elimina todos los socios asociados a un expediente concreto
    * @param exp.
    *            el expediente cuyos socios eliminamos
    * @param tipo 1:socio directo 2:socio indirecto 3:auxiliar externo
    * @throws SQLException
    */
	public void deleteAllByExp(String exp) throws SQLException{
		P06BLog.send(2,this, "Inicio P06B61T00DAO-deleteAllByExp");

		PreparedStatement lstm  = null;
        ResultSet lrst  = null;
        Connection lconConexion = P06BServidorConexionesBD.getConexionConsultas();
        String sql = DELETEALL_BYEXP;
        lstm = lconConexion.prepareStatement(sql);
    	lstm.setString(1,exp.toUpperCase());
    	lstm.executeUpdate();
    	//Cierro recursos
    	try {
    		if(lrst!=null) lrst.close();
    	}catch (Exception rse) {}
        try {
        	if(lstm!=null) lstm.close();
        }catch (Exception sse) {}
        try {
        	if(lconConexion!=null)lconConexion.close();
        }catch (Exception cse) {}
        P06BLog.send(2,this, "Fin P06B61T00DAO-deleteAllByExp");
	}


	/**
    * Elimina todos los socios asociados a un expediente concreto
    * @param exp.
    *            el expediente cuyos socios eliminamos
    * @param tipo 1:socio directo 2:socio indirecto 3:auxiliar externo
    * @throws SQLException
    */
	public void deleteByExpId(String exp, String sCif) throws SQLException{
		P06BLog.send(2,this, "Inicio P06B61T00DAO-deleteByExpId");

		PreparedStatement lstm  = null;
        ResultSet lrst  = null;
        Connection lconConexion = P06BServidorConexionesBD.getConexionConsultas();
        String sql = DELETE_BYEXPID;
        lstm = lconConexion.prepareStatement(sql);
    	lstm.setString(1,exp.toUpperCase());
    	lstm.setString(2,sCif);
    	lstm.executeUpdate();
    	//Cierro recursos
    	try {
    		if(lrst!=null) lrst.close();
    	}catch (Exception rse) {}
        try {
        	if(lstm!=null) lstm.close();
        }catch (Exception sse) {}
        try {
        	if(lconConexion!=null)lconConexion.close();
        }catch (Exception cse) {}
        P06BLog.send(2,this, "Fin P06B61T00DAO-deleteByExpId");
	}


	/**
    * Obtiene el objeto asociado a los parametros de entrada
    * @param expediente.
    * @param tipo 1:socio directo 2:socio indirecto 3:auxiliar externo
    * @param identificador: cif o nif
    * @param idioma
    * @return objeto que cumple los parametros, o null si no lo encuentra
	* @throws Exception
    */
	public P06B61T00Datatype selectByPK(String expediente, String cif, String idioma) throws Exception{
		P06BLog.send(2,this, "Inicio P06B61T00Datatype-selectByPK");
		P06B61T00Datatype obj = null;
		PreparedStatement lstm  = null;
        ResultSet lrst  = null;
        String sql = SELECTALL_BY_PK;
        Connection lconConexion = P06BServidorConexionesBD.getConexionConsultas();
        try {
        	lstm = lconConexion.prepareStatement(sql);
        	lstm.setString(1,expediente.toUpperCase());
        	lstm.setString(2,cif.toUpperCase());
        	lrst = lstm.executeQuery();
	        if(lrst.next()) {
	        	obj = new P06B61T00Datatype();
	        	obj.setCif(lrst.getString(P06BTablas.P06B_P06B61_EV_CIF));
			    obj.setEntidad(lrst.getString(P06BTablas.P06B_P06B61_EV_ENTIDAD));
			    obj.setCalle(lrst.getString(P06BTablas.P06B_P06B61_EV_CALLE)==null?"":lrst.getString(P06BTablas.P06B_P06B61_EV_CALLE));
			    obj.setPortal(lrst.getString(P06BTablas.P06B_P06B61_EV_PORTAL)==null?"":lrst.getString(P06BTablas.P06B_P06B61_EV_PORTAL));
			    obj.setPiso(lrst.getString(P06BTablas.P06B_P06B61_EV_PISO)==null?"":lrst.getString(P06BTablas.P06B_P06B61_EV_PISO));
			    obj.setLetra(lrst.getString(P06BTablas.P06B_P06B61_EV_LETRA)==null?"":lrst.getString(P06BTablas.P06B_P06B61_EV_LETRA));
			    obj.setCodpro(lrst.getString(P06BTablas.P06B_P06B61_EV_CODPRO)==null?"":lrst.getString(P06BTablas.P06B_P06B61_EV_CODPRO));
			    obj.setCodmun(lrst.getString(P06BTablas.P06B_P06B61_EV_CODMUN)==null?"":lrst.getString(P06BTablas.P06B_P06B61_EV_CODMUN));
			    obj.setLocali(lrst.getString(P06BTablas.P06B_P06B61_EV_LOCALID)==null?"":lrst.getString(P06BTablas.P06B_P06B61_EV_LOCALID));
			    obj.setCodpst(lrst.getString(P06BTablas.P06B_P06B61_EV_CODPST)==null?"":lrst.getString(P06BTablas.P06B_P06B61_EV_CODPST));
			    obj.setClavecat(lrst.getString(P06BTablas.P06B_P06B61_EV_CLAVECAT)==null?"":lrst.getString(P06BTablas.P06B_P06B61_EV_CLAVECAT));
			    obj.setFhInscrip(lrst.getString(P06BTablas.P06B_P06B61_EV_FH_INSCRIP)==null?"":P06BFecha.getFechaFormateada(lrst.getDate(P06BTablas.P06B_P06B61_EV_FH_INSCRIP),new Locale(P06BConstantes.P06B_IDIOMA_ES)));
	        }
	        P06BLog.send(2,this, "Fin P06B61T00Datatype-selectByPK");
	    } catch (SQLException e) {
	    	P06BLog.send(2,this, "error: " +e.getMessage());
        	try {
        		if(lrst!=null)
        			lrst.close();
        	}catch (Exception rse) {}
	        try {
	        	if(lstm!=null)
	        		lstm.close();
	        }catch (Exception sse) {}
	        try {
	        	if(lconConexion!=null)
	        		lconConexion.close();
	        }catch (Exception cse) {}
	        //Propago la excepci�n
	        throw e;
	    }catch (Exception e2) {
        	P06BLog.send(2,this, "error: " +e2.getMessage());
        	try {
        		if(lrst!=null)
        			lrst.close();
        	}catch (Exception rse) {}
	        try {
	        	if(lstm!=null)
	        		lstm.close();
	        }catch (Exception sse) {}
	        try {
	        	if(lconConexion!=null)
	        		lconConexion.close();
	        }catch (Exception cse) {}
	        //Propago la excepci�n
	        throw e2;
	    }finally {
	    	try {
        		if(lrst!=null)
        			lrst.close();
        	}catch (Exception rse) {}
	        try {
	        	if(lstm!=null)
	        		lstm.close();
	        }catch (Exception sse) {}
	        try {
	        	if(lconConexion!=null)
	        		lconConexion.close();
	        }catch (Exception cse) {}
	    }
		return obj;
	}


	/**
    * Obtiene el n�mero de objetos del expediente y tipo indicados
    * @param expediente.
    * @param tipo 1:socio directo 2:socio indirecto 3:auxiliar externo
    * @return int con el n�mero de registros encontrados
	* @throws Exception
    */
	public int selectNumObj(String expediente) throws Exception{
		P06BLog.send(2,this, "Inicio P06B61T00Datatype-selectNumObj");
		int numRegsEncontrados = 0;
		PreparedStatement lstm  = null;
        ResultSet lrst  = null;
        String sql = SELECT_NUMREGS;
        Connection lconConexion = P06BServidorConexionesBD.getConexionConsultas();

        try {
        	lstm = lconConexion.prepareStatement(sql);
        	lstm.setString(1,expediente.toUpperCase());
        	lrst = lstm.executeQuery();
	        if (lrst.next()) {
	        	numRegsEncontrados = lrst.getInt(1);
	        }
	        P06BLog.send(2,this, "Fin P06B61T00Datatype-selectNumObj");
	    } catch (SQLException e) {
	    	P06BLog.send(2,this, "error: " +e.getMessage());
        	try {
        		if(lrst!=null)
        			lrst.close();
        	}catch (Exception rse) {}
	        try {
	        	if(lstm!=null)
	        		lstm.close();
	        }catch (Exception sse) {}
	        try {
	        	if(lconConexion!=null)
	        		lconConexion.close();
	        }catch (Exception cse) {}
	        //Propago la excepci�n
	        throw e;
	    }catch (Exception e2) {
        	P06BLog.send(2,this, "error: " +e2.getMessage());
        	try {
        		if(lrst!=null)
        			lrst.close();
        	}catch (Exception rse) {}
	        try {
	        	if(lstm!=null)
	        		lstm.close();
	        }catch (Exception sse) {}
	        try {
	        	if(lconConexion!=null)
	        		lconConexion.close();
	        }catch (Exception cse) {}
	        //Propago la excepci�n
	        throw e2;
	    }finally {
	    	try {
        		if(lrst!=null)
        			lrst.close();
        	}catch (Exception rse) {}
	        try {
	        	if(lstm!=null)
	        		lstm.close();
	        }catch (Exception sse) {}
	        try {
	        	if(lconConexion!=null)
	        		lconConexion.close();
	        }catch (Exception cse) {}
	    }
		return numRegsEncontrados;
	}



	private static String INSERT_COMPLETA =
		"INSERT INTO "+ P06BTablas.P06B_P06B61T00_TABLA +
		"("+
		P06BTablas.P06B_P06B61_EV_NUMEXP + "," +
		P06BTablas.P06B_P06B61_EV_CIF + "," +
		P06BTablas.P06B_P06B61_EV_ENTIDAD + "," +
		P06BTablas.P06B_P06B61_EV_CALLE + "," +
		P06BTablas.P06B_P06B61_EV_PORTAL + "," +
		P06BTablas.P06B_P06B61_EV_PISO + "," +
		P06BTablas.P06B_P06B61_EV_LETRA + "," +
		P06BTablas.P06B_P06B61_EV_CODPRO + "," +
		P06BTablas.P06B_P06B61_EV_CODMUN + "," +
		P06BTablas.P06B_P06B61_EV_LOCALID + "," +
		P06BTablas.P06B_P06B61_EV_CODPST + "," +
		P06BTablas.P06B_P06B61_EV_CLAVECAT + "," +
		P06BTablas.P06B_P06B61_EV_FH_INSCRIP +
		")"+
		" VALUES(?,?,?,?,?,?,?,TO_NUMBER(?),TO_NUMBER(?),TO_NUMBER(?),?,?,TO_DATE(?,'dd/MM/yyyy'))";

	private static String SELECTALL_BY_EXP =
		"SELECT "
		+ P06BTablas.P06B_P06B61_EV_NUMEXP + ", "
		+ P06BTablas.P06B_P06B61_EV_CIF + ", "
		+ P06BTablas.P06B_P06B61_EV_ENTIDAD + ", "
		+ P06BTablas.P06B_P06B61_EV_CALLE + ", "
		+ P06BTablas.P06B_P06B61_EV_PORTAL + ", "
		+ P06BTablas.P06B_P06B61_EV_PISO + ", "
		+ P06BTablas.P06B_P06B61_EV_LETRA + ", "
		+ P06BTablas.P06B_P06B61_EV_CODPRO + ", "
		+ P06BTablas.P06B_P06B61_EV_CODMUN + ", "
		+ P06BTablas.P06B_P06B61_EV_LOCALID + ", "
		+ P06BTablas.P06B_P06B61_EV_CODPST + ", "
		+ P06BTablas.P06B_P06B61_EV_CLAVECAT + ", "
		+ P06BTablas.P06B_P06B61_EV_FH_INSCRIP +
		" FROM " + P06BTablas.P06B_P06B61T00_TABLA;

	private static String SELECTALL_INCORPORACION_BY_EXP =
		" SELECT "
		+ "2 AS operacion, "
		+ "A." + P06BTablas.P06B_P06B61_EV_CIF + ", "
		+ "A." + P06BTablas.P06B_P06B61_EV_ENTIDAD + ", "
		+ "A." + P06BTablas.P06B_P06B61_EV_CALLE + ", "
		+ "A." + P06BTablas.P06B_P06B61_EV_PORTAL + ", "
		+ "A." + P06BTablas.P06B_P06B61_EV_PISO + ", "
		+ "A." + P06BTablas.P06B_P06B61_EV_LETRA + ", "
		+ "A." + P06BTablas.P06B_P06B61_EV_CODPRO + ", "
		+ "A." + P06BTablas.P06B_P06B61_EV_CODMUN + ", "
		+ "A." + P06BTablas.P06B_P06B61_EV_LOCALID + ", "
		+ "A." + P06BTablas.P06B_P06B61_EV_CODPST + ", "
		+ "A." + P06BTablas.P06B_P06B61_EV_CLAVECAT + ", "
		+ "A." + P06BTablas.P06B_P06B61_EV_FH_INSCRIP + ", "
		+ "S." + P06BTablas.P06B_P06B43_CLAVE + ", "
		+ "S." + P06BTablas.P06B_P06B43_DENOM + ", "
		+ "S." + P06BTablas.P06B_P06B43_FH_INSCRIP
		+ " FROM " + P06BTablas.P06B_P06B61T00_TABLA + " A,"
		+ P06BTablas.P06B_P06B43T00_TABLA + " S"
		+ " WHERE "
		+ "S." + P06BTablas.P06B_P06B43_NUMEXP + "=?"
		+ " AND S." + P06BTablas.P06B_P06B43_EJERCICIO + "=?"
		+ " AND A." + P06BTablas.P06B_P06B61_EV_NUMEXP + "=S." + P06BTablas.P06B_P06B43_NUMEXP
		+ " AND A." + P06BTablas.P06B_P06B61_EV_CLAVECAT + "=S." + P06BTablas.P06B_P06B43_CLAVE
		+ " UNION"
		+ " SELECT 0, "
		+ "A." + P06BTablas.P06B_P06B61_EV_CIF + ", "
		+ "A." + P06BTablas.P06B_P06B61_EV_ENTIDAD + ", "
		+ "A." + P06BTablas.P06B_P06B61_EV_CALLE + ", "
		+ "A." + P06BTablas.P06B_P06B61_EV_PORTAL + ", "
		+ "A." + P06BTablas.P06B_P06B61_EV_PISO + ", "
		+ "A." + P06BTablas.P06B_P06B61_EV_LETRA + ", "
		+ "A." + P06BTablas.P06B_P06B61_EV_CODPRO + ", "
		+ "A." + P06BTablas.P06B_P06B61_EV_CODMUN + ", "
		+ "A." + P06BTablas.P06B_P06B61_EV_LOCALID + ", "
		+ "A." + P06BTablas.P06B_P06B61_EV_CODPST + ", "
		+ "A." + P06BTablas.P06B_P06B61_EV_CLAVECAT + ", "
		+ "A." + P06BTablas.P06B_P06B61_EV_FH_INSCRIP + ", "
		+ "NULL, NULL, NULL"
		+ " FROM " + P06BTablas.P06B_P06B61T00_TABLA + " A,("
		+ "SELECT "
		+ P06BTablas.P06B_P06B61_EV_CLAVECAT + " FROM " + P06BTablas.P06B_P06B61T00_TABLA + " T1"
		+ " WHERE "
		+ "T1." + P06BTablas.P06B_P06B61_EV_NUMEXP + "=?"
		+ " MINUS "
		+ "SELECT "
		+ "S." + P06BTablas.P06B_P06B43_CLAVE + " FROM " + P06BTablas.P06B_P06B43T00_TABLA + " S"
		+ " WHERE "
		+ "S." + P06BTablas.P06B_P06B43_NUMEXP + "=?"
		+ " AND S." + P06BTablas.P06B_P06B43_EJERCICIO + "=?"
		+ " ) C"
		+ " WHERE "
		+ "A." + P06BTablas.P06B_P06B61_EV_NUMEXP + "=?"
		+ " AND C." + P06BTablas.P06B_P06B61_EV_CLAVECAT + "=A." + P06BTablas.P06B_P06B61_EV_CLAVECAT
		+ " UNION"
		+ " SELECT "
		+ "1, "
		+ "NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "
		+ "NULL, NULL, NULL, NULL, "
		+ "A." + P06BTablas.P06B_P06B43_CLAVE + ", "
		+ "A." + P06BTablas.P06B_P06B43_DENOM + ", "
		+ "A." + P06BTablas.P06B_P06B43_FH_INSCRIP
		+ " FROM " + P06BTablas.P06B_P06B43T00_TABLA + " A,("
		+ "SELECT "
		+ "S." + P06BTablas.P06B_P06B43_CLAVE + " FROM " + P06BTablas.P06B_P06B43T00_TABLA + " S"
		+ " WHERE "
		+ "S." + P06BTablas.P06B_P06B43_NUMEXP + "=?"
		+ " AND S." + P06BTablas.P06B_P06B43_EJERCICIO + "=?"
		+ " MINUS "
		+ "SELECT "
		+ P06BTablas.P06B_P06B61_EV_CLAVECAT + " FROM " + P06BTablas.P06B_P06B61T00_TABLA + " T1"
		+ " WHERE "
		+ "T1." + P06BTablas.P06B_P06B61_EV_NUMEXP + "=?) C"
		+ " WHERE "
		+ "A." + P06BTablas.P06B_P06B43_NUMEXP + "=?"
		+ " AND C." + P06BTablas.P06B_P06B43_CLAVE + "=A." + P06BTablas.P06B_P06B43_CLAVE
		+ " ORDER BY 1 DESC,2";


	private static String SELECTALL_INCORPORACIONMODTRAMITAGUNE_BY_EXP =
		" SELECT "
		+ "2 AS operacion, "
		+ "A." + P06BTablas.P06B_P06B61_EV_CIF + ", "
		+ "A." + P06BTablas.P06B_P06B61_EV_ENTIDAD + ", "
		+ "A." + P06BTablas.P06B_P06B61_EV_CALLE + ", "
		+ "A." + P06BTablas.P06B_P06B61_EV_PORTAL + ", "
		+ "A." + P06BTablas.P06B_P06B61_EV_PISO + ", "
		+ "A." + P06BTablas.P06B_P06B61_EV_LETRA + ", "
		+ "A." + P06BTablas.P06B_P06B61_EV_CODPRO + ", "
		+ "A." + P06BTablas.P06B_P06B61_EV_CODMUN + ", "
		+ "A." + P06BTablas.P06B_P06B61_EV_LOCALID + ", "
		+ "A." + P06BTablas.P06B_P06B61_EV_CODPST + ", "
		+ "A." + P06BTablas.P06B_P06B61_EV_CLAVECAT + ", "
		+ "A." + P06BTablas.P06B_P06B61_EV_FH_INSCRIP + ", "
		+ "A." + P06BTablas.P06B_P06B61_EV_CIF + " AS " + P06BTablas.P06B_P06B71_EV_CIF + ", "
		+ "A." + P06BTablas.P06B_P06B61_EV_CLAVECAT + " AS " + P06BTablas.P06B_P06B71_EV_CLAVECAT + ", "
		+ "A." + P06BTablas.P06B_P06B61_EV_ENTIDAD + " AS " + P06BTablas.P06B_P06B71_EV_ENTIDAD + ", "
		 + "1 AS " + P06BTablas.P06B_P06B71_EV_ALTABAJA
		+ " FROM " + P06BTablas.P06B_P06B61T00_TABLA + " A,("
		+ "SELECT "
		+ P06BTablas.P06B_P06B61_EV_CLAVECAT + " FROM " + P06BTablas.P06B_P06B61T00_TABLA + " T1"
		+ " WHERE "
		+ "T1." + P06BTablas.P06B_P06B61_EV_NUMEXP + "=? MINUS SELECT "
		+ "S." + P06BTablas.P06B_P06B71_EV_CLAVECAT + " FROM " + P06BTablas.P06B_P06B71T00_TABLA + " S"
		+ " WHERE "
		+ "S." + P06BTablas.P06B_P06B71_EV_NUMEXP + "=?"
		+ " AND S." + P06BTablas.P06B_P06B71_EV_CORRELATENCPETIC + "=?) C"
		+ " WHERE "
		+ "A." + P06BTablas.P06B_P06B61_EV_NUMEXP + "=?"
		+ " AND C." + P06BTablas.P06B_P06B61_EV_CLAVECAT + "=A." + P06BTablas.P06B_P06B61_EV_CLAVECAT
		+ " UNION"
		+ " SELECT "
		+ "2 AS operacion, "
		+ "A." + P06BTablas.P06B_P06B61_EV_CIF + ", "
		+ "A." + P06BTablas.P06B_P06B61_EV_ENTIDAD + ", "
		+ "A." + P06BTablas.P06B_P06B61_EV_CALLE + ", "
		+ "A." + P06BTablas.P06B_P06B61_EV_PORTAL + ", "
		+ "A." + P06BTablas.P06B_P06B61_EV_PISO + ", "
		+ "A." + P06BTablas.P06B_P06B61_EV_LETRA + ", "
		+ "A." + P06BTablas.P06B_P06B61_EV_CODPRO + ", "
		+ "A." + P06BTablas.P06B_P06B61_EV_CODMUN + ", "
		+ "A." + P06BTablas.P06B_P06B61_EV_LOCALID + ", "
		+ "A." + P06BTablas.P06B_P06B61_EV_CODPST + ", "
		+ "A." + P06BTablas.P06B_P06B61_EV_CLAVECAT + ", "
		+ "A." + P06BTablas.P06B_P06B61_EV_FH_INSCRIP + ", "
		+ "S." + P06BTablas.P06B_P06B71_EV_CIF + ", "
		+ "S." + P06BTablas.P06B_P06B71_EV_CLAVECAT + ", "
		+ "S." + P06BTablas.P06B_P06B71_EV_ENTIDAD + ", "
		+ "S." + P06BTablas.P06B_P06B71_EV_ALTABAJA
		+ " FROM " + P06BTablas.P06B_P06B61T00_TABLA + " A,"
		+ P06BTablas.P06B_P06B71T00_TABLA + " S"
		+ " WHERE "
		+ "S." + P06BTablas.P06B_P06B71_EV_NUMEXP + "=?"
		+ " AND S." + P06BTablas.P06B_P06B71_EV_CORRELATENCPETIC + "=?"
		+ " AND S." + P06BTablas.P06B_P06B71_EV_ALTABAJA + "=?"
		+ " AND A." + P06BTablas.P06B_P06B61_EV_NUMEXP + "=S." + P06BTablas.P06B_P06B71_EV_NUMEXP
		+ " AND A." + P06BTablas.P06B_P06B61_EV_CLAVECAT + "=S." + P06BTablas.P06B_P06B71_EV_CLAVECAT
		+ " UNION"
		+ " SELECT "
		+ "1, "
		+ "NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "
		+ "NULL, NULL, NULL, NULL, "
		+ "A." + P06BTablas.P06B_P06B71_EV_CIF + ", "
		+ "A." + P06BTablas.P06B_P06B71_EV_CLAVECAT + ", "
		+ "A." + P06BTablas.P06B_P06B71_EV_ENTIDAD + ", "
		+ "A." + P06BTablas.P06B_P06B71_EV_ALTABAJA
		+ " FROM " + P06BTablas.P06B_P06B71T00_TABLA + " A,("
		+ "SELECT "
		+ "S." + P06BTablas.P06B_P06B71_EV_CLAVECAT + " FROM " + P06BTablas.P06B_P06B71T00_TABLA + " S"
		+ " WHERE "
		+ "S." + P06BTablas.P06B_P06B71_EV_NUMEXP + "=?"
		+ " AND S." + P06BTablas.P06B_P06B71_EV_CORRELATENCPETIC + "=?"
		+ " AND S." + P06BTablas.P06B_P06B71_EV_ALTABAJA + "=?"
		+ " MINUS "
		+ "SELECT "
		+ P06BTablas.P06B_P06B61_EV_CLAVECAT + " FROM " + P06BTablas.P06B_P06B61T00_TABLA + " T1"
		+ " WHERE "
		+ "T1." + P06BTablas.P06B_P06B61_EV_NUMEXP + "=?) C"
		+ " WHERE "
		+ "A." + P06BTablas.P06B_P06B71_EV_NUMEXP + "=?"
		+ " AND C." + P06BTablas.P06B_P06B71_EV_CLAVECAT + "=A." + P06BTablas.P06B_P06B71_EV_CLAVECAT
		+ " ORDER BY 1 DESC,2";


	private static String DELETEALL_BYEXP =
		"DELETE FROM "+ P06BTablas.P06B_P06B61T00_TABLA +
		" WHERE " + P06BTablas.P06B_P06B61_EV_NUMEXP + " = ?";


	private static String DELETE_BYEXPID =
		"DELETE FROM "+ P06BTablas.P06B_P06B61T00_TABLA +
		" WHERE " + P06BTablas.P06B_P06B61_EV_NUMEXP + " = ?" +
		" AND " + P06BTablas.P06B_P06B61_EV_CIF + " = ?";


	private static String SELECTALL_BY_PK =
		"SELECT "
		+ P06BTablas.P06B_P06B61_EV_NUMEXP + ", "
		+ P06BTablas.P06B_P06B61_EV_CIF + ", "
		+ P06BTablas.P06B_P06B61_EV_ENTIDAD + ", "
		+ P06BTablas.P06B_P06B61_EV_CALLE + ", "
		+ P06BTablas.P06B_P06B61_EV_PORTAL + ", "
		+ P06BTablas.P06B_P06B61_EV_PISO + ", "
		+ P06BTablas.P06B_P06B61_EV_LETRA + ", "
		+ P06BTablas.P06B_P06B61_EV_CODPRO + ", "
		+ P06BTablas.P06B_P06B61_EV_CODMUN + ", "
		+ P06BTablas.P06B_P06B61_EV_LOCALID + ", "
		+ P06BTablas.P06B_P06B61_EV_CODPST + ", "
		+ P06BTablas.P06B_P06B61_EV_CLAVECAT + ", "
		+ P06BTablas.P06B_P06B61_EV_FH_INSCRIP +
		" FROM " + P06BTablas.P06B_P06B61T00_TABLA
		+ " WHERE " + P06BTablas.P06B_P06B61_EV_NUMEXP + "= ?"
			+ " AND " + P06BTablas.P06B_P06B61_EV_CIF + "= ?";

	private static String SELECT_NUMREGS =
		"SELECT COUNT(*) "
		+" FROM " + P06BTablas.P06B_P06B61T00_TABLA
		+" WHERE " + P06BTablas.P06B_P06B61_EV_NUMEXP + "= ? ";


}
